package demo.frame;

import java.io.UnsupportedEncodingException;

import javax.swing.ImageIcon;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import netsdk.lib.CommonFunctions;
import netsdk.lib.DeviceSdk;

public class RunableTest implements Runnable {
	private NativeLong IPCid ;       // 表示线程的名称 
	public RunableTest(NativeLong id){ 
	     this.IPCid = id ;      // 通过构造方法配置name属性 
	  }

    @Override

    public void run() {

    	String szUrl = "AddTargetFace";
		String tempXML = "<?xml version = '1.0' encoding='utf-8'?>" +
                                        "<config version='1.7' xmlns='http://www.ipc.com/ver10' >" +
                                        "<types>" +
                                        "<listType> " +
                                          "<enum>strangerList</enum>" + 
                                          "<enum>whiteList</enum>" +  
                                          "<enum>blackList</enum>" + 
                                        "</listType>" +  
                                        "<sexType>" + 
                                          "<enum>male</enum>" +  
                                          "<enum>female</enum>" + 
                                        "</sexType>" +  
                                        "<formatType>" + 
                                          "<enum>jpg</enum>" +                                         
                                        "</formatType>" + 
                                        "</types>" +
                                        "<personInfo>" +
                                        "<listType type='listType'>%s</listType>" + //目标类型，白名单或者黑名单
                                        "<name type='string' maxLen='127'><![CDATA[%s]]></name>" +  //此处名称为UTF8格式字符串
                                        "<sex type='sexType'>%s</sex>" +
                                        "<age type='uint32'>%d</age>" +
                                        "<identifyNumber type='string' maxLen='127'><![CDATA[%s]]></identifyNumber>" +
                                        "<telephone type='string' maxLen='63'><![CDATA[%s]]></telephone>" +                                       
                                        "</personInfo>" +
                                        "<faceImgs type='list' maxCount='5' count='%d'>" +  //图片张数
                                        "<item>" +
                                        "<pictureData><![CDATA[%s]]></pictureData>" +  //图片数据，Base64String
                                        "<pictureNum>%d</pictureNum>" +
                                        "<Width>%d</Width>" +
                                        "<Height>%d</Height>" +  
                                        "<Height>%d</Height>" +
                                        "<format>%s</format>" +  //图片格式，"jpg"
                                        "<size>%d</size>" +
                                        "</item>" +
                                        "</faceImgs>" +
                                    "</config>";		
		
		byte[] nameArr;
		String name = "";
		try {
			nameArr = "1".getBytes("UTF-8");
			name = new String(nameArr);
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		String listType = "whiteList";
		
		//String name = "333";
		String sex = "female";
		int age = 18;
		String identifyNumber = "1";
		String telephone = "1";
		int count = 1;
		String pictureData = CommonFunctions.getImageStr("C:\\Users\\8590\\Desktop\\3.jpg");
		//String pictureData ="";
		int pictureNum = 1;
		ImageIcon imageIcon = new ImageIcon("C:\\\\Users\\\\8590\\\\Desktop\\\\3.jpg"); 
		int Width = imageIcon.getIconWidth(); 
		int Height = imageIcon.getIconHeight();
		String format = "jpg";
		int size = CommonFunctions.pathSize("C:\\\\Users\\\\8590\\\\Desktop\\\\3.jpg");

		String sendXml = String.format(tempXML, listType,name,sex,age,identifyNumber,telephone,count,
				pictureData,pictureNum,Width,Height,Height,format,size);
		System.out.println(sendXml);
		//String sendXml = targetInfo.replaceFirst("<sex type=\"sexType\">male</sex>", "<sex type=\"sexType\">female</sex>");
		IntByReference lpBytesReturned = new IntByReference();
		Pointer pNativeData = new Memory(1024 * 1024); 	       
		//boolean ret = DeviceSdk.INSTANCE.NET_SDK_TransparentConfig(loginId, tempXML, szUrl, pNativeData, 1024 * 1024, lpBytesReturned);
        
        boolean ret = DeviceSdk.INSTANCE.NET_SDK_TransparentConfig(IPCid, sendXml, szUrl, pNativeData, 1024 * 1024, lpBytesReturned);
        if (ret)
        {

        	byte[] data = pNativeData.getByteArray(0, lpBytesReturned.getValue());
        	String temp = CommonFunctions.ByteToStr(data,"UTF8");  
        	
			System.out.println(temp);								
        }
     // 释放内存
		long peer = Pointer.nativeValue(pNativeData);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(pNativeData, 0);				

    }

    public static void main(String[] args) {

    	NativeLong IPC1 = new NativeLong();//用注册回调得到的设备id
    	NativeLong IPC2 = new NativeLong();//用注册回调得到的设备id
    	
        RunableTest runableTest1 = new RunableTest(IPC1);

        RunableTest runableTest2 = new RunableTest(IPC2);

        new Thread(runableTest1).start();

        new Thread(runableTest2).start();

    }

}